Unit uentier;
{ procdures et fonction de base pour calculer avec des entiers longs }

INTERFACE
{ on dclare dans cette partie tout ce qui sera utilisable par
  d'autres programmes ou units }

Const
 nMax=255; { nombre maximum de chiffres pour un entier }

Type
 { type reprsentant un entier long }
 Entier=record
  taille : Integer;
  { nombre de chiffres; l'entier n'est pas valide si 0 }
  chiffres : array[1..nMax] of Byte;
  { sauf pour 0 le premier chiffre est toujours diffrent de 0 }
  end;

Procedure Normalise(var e:Entier);
{ supprime les ventuels 0 du dbut du tableau de chiffres }

Procedure FaireEntier(S:String; var e:Entier);
{ transforme la chaine de caractres S en un entier e }

Procedure Convertir(n:LongInt; var e:Entier);
{ convertit le LongInt n en entier long e }

Procedure Lire(var e:Entier);
{ entre de l'entier e au clavier }

Procedure Afficher(e:Entier);
{ affichage de l'entier e }

Procedure Hasard(var e:Entier; l:Integer);
{ cre l'entier e au hasard;
  si l>0 avec l chiffres
  si l<0 avec au plus l chiffres }

Function Compare(e1,e2:Entier):Integer;
{ renvoie 1 si e1>e2, 0 si e1=e2, -1 si e1<e2 }

Procedure Permuter(var e1,e2:Entier);
{ remplace e1 par e2 et e2 par e1 }

Procedure Addition(e1,e2:Entier; var e:Entier);
{ renvoie e1+e2 dans e }

Procedure Soustraction(e1,e2:Entier; var e:Entier);
{ renvoie e1-e2 dans e }

Procedure Multiplication(e1,e2:Entier; var e:Entier);
{ renvoie le produit de e1 et e2 dans e }

Procedure Division(e1,e2:Entier; var e,r:Entier);
{ effectue la division euclidienne de e1 par e2, renvoie
  le quotient dans e et le reste dans r }

Procedure AddB(var e:Entier; b:Byte);
{ ajoute le chiffre b  e }

Procedure SousB(var e:Entier; b:Byte);
{ Soustrait le chiffre b de e }

Procedure MultB(var e:Entier; b:Byte);
{ multiplie e par le chiffre b }

Procedure DivB(var e:Entier; b:Byte);
{ divise e par le chiffre b }

Procedure Mult10(var e:Entier);
{ multiplie e par 10 }

IMPLEMENTATION

Procedure Normalise(var e:Entier);
{ supprimer les 0 du dbut }
Var i,d:Integer;
Begin
 { trouver le premier chiffre non nul }
 d:=1;
 while (d<e.taille) and (e.chiffres[d]=0) do inc(d);
 if d>1 then
  begin
   e.taille:=e.taille-d+1;
   for i:=1 to e.taille do e.chiffres[i]:=e.chiffres[i+d-1];
  end;
End;

Procedure Mult10(var e:Entier);
{ multiplie e par 10 }
Begin
 if e.taille=Nmax then
  begin
   e.taille:=0; exit; { dpassement de capacit }
  end;
 { multiplication par 0 }
 if e.chiffres[1]=0 then exit;
 { autres cas }
 inc(e.Taille);
 e.chiffres[e.taille]:=0;
End;

Procedure AddB(var e:Entier; b:Byte);
Var
 i:Integer;
 retenue:Byte;
Begin
 if e.Taille<=0 then exit;
 retenue:=b;
 i:=e.Taille;
 while (retenue<>0) and (i>0) do
  begin
   e.Chiffres[i]:=e.Chiffres[i]+retenue;
   if e.Chiffres[i]>=10 then
    begin
     e.Chiffres[i]:=e.Chiffres[i]-10;
     retenue:=1;
    end
   else retenue:=0;
   dec(i);
  end;
 if retenue>0 then
  begin
   if e.taille<Nmax then
    begin
     inc(e.taille);
     for i:=e.taille downto 2 do e.chiffres[i]:=e.chiffres[i-1];
     e.chiffres[1]:=retenue;
    end
   else e.taille:=0; { dbordement de capacit }
  end;
End;

Procedure SousB(var e:Entier; b:Byte);
Var
 i:Integer;
 retenue:Byte;
Begin
 if e.Taille<=0 then exit;
 retenue:=b;
 i:=e.Taille;
 while (retenue<>0) and (i>0) do
  begin
   e.Chiffres[i]:=10+e.Chiffres[i]-retenue;
   if e.Chiffres[i]>=10 then
    begin
     e.Chiffres[i]:=e.Chiffres[i]-10;
     retenue:=0;
    end
   else retenue:=1;
   dec(i);
  end;
 if retenue>0 then
  begin
   e.Taille:=0; exit;
  end;
 Normalise(e);
End;

Procedure MultB(var e:Entier; b:Byte);
{ multiplie e1 par le chiffre b et met le rsultat dans e }
Var
 i:Integer;
 retenue : Byte;
Begin
 if (b=1) or (e.Taille<=0) then exit;
 if b=0 then
  begin
   Convertir(0,e); exit;
  end;
 retenue:=0;
 for i:=e.taille downto 1 do
  begin
   e.Chiffres[i]:=e.Chiffres[i]*b+retenue;
   retenue:=e.Chiffres[i] div 10;
   e.Chiffres[i]:=e.Chiffres[i] mod 10;
  end;
 { traitement de la dernire retenue }
 if retenue>0 then
  begin
   if e.taille<Nmax then
    begin
     inc(e.taille);
     for i:=e.taille downto 2 do e.chiffres[i]:=e.chiffres[i-1];
     e.chiffres[1]:=retenue;
    end
   else e.taille:=0; { dbordement de capacit }
  end;
End;

Procedure DivB(var e:Entier; b:Byte);
Var
 i : Integer;
 r : Byte;
 q : Entier;
Begin
 if (b=1) or (e.Taille<=0) then exit;
 if b=0 then
  begin
   e.Taille:=0; exit;
  end;
 Convertir(0,q);
 r:=0;
 for i:=1 to e.Taille do
  begin
   Mult10(q);
   q.Chiffres[q.Taille]:=(10*r+e.Chiffres[i]) div b;
   r:=e.Chiffres[i] mod b;
  end;
   e:=q;
End;

Procedure Convertir(n:LongInt; var e:Entier);
{ convertit le LongInt n en entier long e }
Var k:LongInt;
Begin
 { e=0 }
 e.Taille:=1; e.Chiffres[1]:=0;
 k:=1;
 while (k<n) and (k<1000000000) do k:=k*10;
 repeat
  Mult10(e);
  e.Chiffres[e.Taille]:=n div k;
  n:=n mod k;
  k:=k div 10;
 until k=0;
End;

Procedure FaireEntier(S:String; var e:Entier);
{ transforme la chaine de caractres S en un entier e }
Var
 i : Integer;
 erreur : Boolean;
Begin
 if S='' then erreur:=true else erreur:=false;
 for i:=1 to length(S) do
  if (S[i]>='0') and (S[i]<='9') then
   e.Chiffres[i]:=ord(S[i])-ord('0')
  else erreur:=true;
 if erreur then e.taille:=0
 else
  begin
   e.taille:=length(S);
   Normalise(e);
  end;
End;

Procedure Lire(var e:Entier);
Var
 S:String;
Begin
 write('Entrer un entier : '); readln(S);
 FaireEntier(S,e);
End;

Procedure Afficher(e:Entier);
Var i:Integer;
Begin
 if e.Taille<=0 then
  writeln('Entier non valide.')
 else
  for i:=1 to e.Taille do write(e.chiffres[i]);
End;

Procedure Hasard(var e:Entier; l:Integer);
{ cre l'entier e au hasard;
  si l>0 avec l chiffres
  si l<0 avec au plus l chiffres }
Var i:Integer;
Begin
 if (l=0) or (l>Nmax) then
  begin
   e.taille:=0; exit;
  end;
 if l>0 then e.taille:=l
 else
  begin
   l:=-l; e.taille:=1+random(l);
  end;
 { le premier chiffre est diffrent de 0 }
 e.chiffres[1]:=1+random(9);
 for i:=2 to e.taille do e.chiffres[i]:=random(10);
End;

Function Compare(e1,e2:Entier):Integer;
{ renvoie 1 si e1>e2, 0 si e1=e2, -1 si e1<e2 }
Var i,rep:Integer;
Begin
 if e1.taille>e2.taille then rep:=1
 else if e1.taille<e2.taille then rep:=-1
 else
  begin
   rep:=0; i:=1;
   while (rep=0) and (i<=e1.taille) do
    begin
     if e1.chiffres[i]>e2.chiffres[i] then rep:=1
     else if e1.chiffres[i]<e2.chiffres[i] then rep:=-1
     else inc(i);
    end;
  end;
 Compare:=rep;
End;

Procedure Permuter(var e1,e2:Entier);
{ remplace e1 par e2 et e2 par e1 }
Var tmp:Entier;
Begin
 tmp:=e1;
 e1:=e2;
 e2:=tmp;
End;

Procedure Addition(e1,e2:Entier; var e:Entier);
{ renvoie e1+e2 dans e }
Var
 i,d : Integer;
 retenue : Byte;
Begin
 if (e1.Taille<=0) or (e2.Taille<=0) then
  begin
   e.Taille:=0; exit;
  end;
 { initialiser }
 { chercher d la diffrence entre les nombres de chiffres
   placer le plus long dans e et le plus court dans e2 }
 d:=e1.taille-e2.taille;
 if d>=0 then e:=e1
 else
  begin
   e:=e2;
   e2:=e1;
   d:=-d;
  end;
 { initialiser la retenue }
 retenue:=0;
 { ajouter les chiffres en commun }
 for i:=e.taille downto d+1 do
  begin
   e.chiffres[i]:=e.chiffres[i]+e2.chiffres[i-d]+retenue;
   { traitement de la retenue }
   if e.chiffres[i]>=10 then
    begin
     retenue:=1;
     e.chiffres[i]:=e.chiffres[i]-10;
    end
   else retenue:=0;
  end;
 { transmission de la retenue }
 i:=d;
 while (i>0) and (retenue>0) do
  begin
   e.chiffres[i]:=e.chiffres[i]+retenue;
   if e.chiffres[i]>=10 then
    begin
     e.chiffres[i]:=e.chiffres[i]-10;
     retenue:=1;
    end
   else retenue:=0;
   dec(i);
  end;
 { dernire retenue }
 if retenue>0 then
  begin
   if e.taille<Nmax then
    begin
     inc(e.taille);
     for i:=e.taille downto 2 do e.chiffres[i]:=e.chiffres[i-1];
     e.chiffres[1]:=retenue;
    end
   else e.taille:=0; { dbordement de capacit }
  end;
End;

Procedure Soustraction(e1,e2:Entier; var e:Entier);
{ renvoie e1-e2 dans e }
Var
 i,d : Integer;
 retenue : Byte;
Begin
 if (e1.Taille<=0) or (e2.Taille<=0) then
  begin
   e.Taille:=0; exit;
  end;
 d:=e1.taille-e2.taille;
 if d<0 then
  begin
   e.taille:=0; exit;
  end;
 e:=e1;
 retenue:=0;
 for i:=e.taille downto d+1 do
  begin
   e.chiffres[i]:=10+e.chiffres[i]-e2.chiffres[i-d]-retenue;
   { traitement de la retenue }
   if e.chiffres[i]>=10 then
    begin
     e.chiffres[i]:=e.chiffres[i]-10; retenue:=0;
    end
   else retenue:=1;
  end;
 { transmission de la retenue }
 i:=d;
 while (i>0) and (retenue>0) do
  begin
   e.chiffres[i]:=10+e.chiffres[i]-retenue;
   if e.chiffres[i]>=10 then
    begin
     e.chiffres[i]:=e.chiffres[i]-10; retenue:=0;
    end
   else retenue:=1;
   dec(i);
  end;
 { traitement de la dernire retenue }
 if retenue=1 then
  begin
   e.taille:=0; exit;
  end;
 if e.chiffres[1]=0 then Normalise(e);
End;

Procedure Multiplication(e1,e2:Entier; var e:Entier);
Var
 i   : Integer;
 tmp : Entier;
Begin
 if (e1.Taille<=0) or (e2.Taille<=0) then
  begin
   e.Taille:=0;  exit;
  end;
 { e=0 }
 e.Taille:=1; e.Chiffres[1]:=0;
 { il vaut mieux que e1 soit le plus long }
 if e1.Taille<e2.Taille then Permuter(e1,e2);
 { multiplication par 0 }
 { if e2.Chiffres[1]=0 then exit; }
 i:=1;
 while (e.Taille>0) and (i<=e2.Taille) do
  begin
   Mult10(e);
   if e2.Chiffres[i]<>0 then
    begin
     if e2.Chiffres[i]>1 then
      begin
	   tmp:=e1;
       MultB(tmp,e2.Chiffres[i]);
       Addition(e,tmp,e);
      end
     else Addition(e,e1,e);
    end;
   {for k:=1 to e2.Chiffres[i] do Addition(e,e1,e);}
   inc(i);
  end;
End;

Procedure Division(e1,e2:Entier; var e,r:Entier);
{ effectue la division euclidienne de e1 par e2, renvoie
  le quotient dans e et le reste dans r }
Var
 n : Integer;
 q : Byte;
Begin
 if (e1.Taille<=0) or (e2.Taille<=0) then
  begin
   e.Taille:=0;  exit;
  end;
 if e2.Chiffres[1]=0 then
  begin
   { pas de division par 0 }
   e.Taille:=0; r.Taille:=0; exit;
  end;
 { e=0 }
 e.Taille:=1; e.Chiffres[1]:=0;
 { n nombre de chiffres du quotient  1 prs }
 n:=1;
 while e2.Taille<e1.Taille do
  begin
   Mult10(e2);
   inc(n);
  end;
 r:=e1;
 while n>=1 do
  begin
   q:=0;
   while Compare(r,e2)>=0 do
    begin
     Soustraction(r,e2,r);
     inc(q);
    end;
   { inscrire le chiffre q; un zro en dbut n'est pas inscrit }
   Mult10(e);
   if e.Taille>0 then e.Chiffres[e.Taille]:=q;
   { diviser e2 par 10 }
   dec(e2.Taille);
   dec(n);
  end;
End;

BEGIN
 randomize;
END.
