Program PI;
{ Programme de calcul des dcimales de pi }
{
  Ce programme calcule les dcimales de PI en utilisant la formule

            PI/4 = 4 ARCTAN(1/5) - ARCTAN(1/239) .
                  (formule de Machin)

  Le calcul de la fonction ArcTan se fait avec son dveloppement en
srie entire. Le terme gnral de cette srie est
             n
         (-1)    2n+1
       -------- x
       (2n + 1)

et la somme de la srie se fait de N=0  l'infini.

  On obtient finalement la formule suivante, en utilisant une mthode
classique de la valeur d'un polynome (mthode de Horner) :
                      1    1     1    1      1
    ARCTAN(X)=X(1+X(--+X(-+X(--+X(-+X(---+X(.........
                      3    5     7    9     11

  Remarque : le nombre de termes  calculer pour obtenir ArcTan(1/d) avec
la prcision dsire est donn par la formule :
       pln(10)
   n > -------
       2ln(d)
   o n est le nombre de termes  calculer,
   et p le nombre de dcimales dsires.
}

Uses uentier;  { unit de traitement des entiers longs }

Const NombreChiffres = 200;

Procedure Unite(var e:Entier);
Var i:Integer;
Begin
 Convertir(1,e);
 for i:=1 to NombreChiffres do MultB(e,10);
End;

Procedure ArcTanX(var Res:Entier; d:LongInt);
{ calcule arctan(1/d) en utilisant la mthode de Horner }
{ pour n'avoir que des termes positifs : on regroupe les termes 2 par 2 }
{ optimisation du nombre de termes calculs }
Var tmp,d2 : Entier;    { rsultat temporaire, d*d }
    n,                  { moiti du nombre de terme  calculer }
    i   : LongInt;      { compteur de termes }
    r   : Entier;       { restes, non utiliss }
Begin
 { nombre de termes  calculer }
 { Formule utilise :
   n>(1/2)*p*ln(10)/ln(d)
   o n est le nombre de termes  calculer
   et p le nombre de dcimales dsires }
 n:=round(NombreChiffres*ln(10)/(2*ln(d)));
 Unite(Res);
 Convertir(d,d2);
 Multiplication(d2,d2,d2);
 for i:=n downto 0 do
  begin
   division(Res,d2,Res,r);
   division(Res,d2,Res,r);
   Unite(tmp);
   Convertir(4*i+1,r);
   division(tmp,r,tmp,r);
   addition(Res,tmp,Res);
   Unite(tmp);
   Convertir(4*i+3,r);
   division(tmp,r,tmp,r);
   division(tmp,d2,tmp,r);
   soustraction(Res,tmp,Res);
  end;
 Convertir(d,d2);
 division(Res,d2,Res,r);
End;

Var
 n1,n2 : Entier;

BEGIN
 writeln('Calcul des ',NombreChiffres,' premires dcimales de PI.');
 writeln;
 writeln('Patience, je calcule ...');
 writeln;
 arctanx(n1,5);            { arctan(1/5) }
 multB(n1,4);              { 4*arctan(1/5) }
 arctanx(n2,239);          { arctan(1/239) }
 soustraction(n1,n2,n1);   { 4*arctan(1/5)-arctan(1/239) }
 multB(n1,4);              { 4*(4*arctan(1/5)-arctan(1/239)) }
 Afficher(n1);
 writeln;
 readln;
END.

Rsultats obtenus :

Calcul des 200 premires dcimales de PI.
31415926535897932384626433832795028841971693993751058209749445923078164062862089
98628034825342117067982148086513282306647093844609550582231725359408128481117450
28410270193852110555964462294895493038184

Rsultat fourni par Mupad :

31415926535897932384626433832795028841971693993751058209749445923078164062862089
98628034825342117067982148086513282306647093844609550582231725359408128481117450
2841027019385211055596446229489549303819

Note : il y a un problme avec les 2 derniers chiffres; sans doute du 
l'accumulation des arrondis
