Program Calc_e;
{ calcul des dcimales du nombre e }
{
Biblio : Mathmatique lmentaire d'un point de vue algorithmique
         (pages 210-211)
         Arthur Engel
         Edition Cedic 1979

Principe du calcul :
------------------
 e est la somme de la srie de terme gnral 1/n!.
 On va donc utiliser la suite e(n)=1+1/1!+1/2!+...+1/n! pour calculer une
valeur approche de e.
 On dmontre facilement que e-e(n)<[(n+2)/(n+1)]*[1/(n+1)!]. Pour n=144
l'erreur commise en remplaant e par e(n) est infrieure  la valeur de la
251me dcimale, on obtient donc une prcision suffisante pour calculer
les 250 premires dcimales de e.

Note :
----
 C'est par cette mthode que D. Gillies et D. Wheeler ont calcul en 1964
un million de dcimales de e. Ils ont utiliss la base 10^10.
}

Uses uentier;

Var Rep,di,p10,r : Entier;
    i  : Integer;
    t  : Real;

BEGIN
 writeln('Calcul des 250 premires dcimales du nombre e.');
 writeln('...');
 Convertir(1,Rep);
 for i:=1 to 250 do MultB(Rep,10);
 p10:=Rep;
 {pour n allant de 144  1 on fait :
  -diviser par n
  -ajouter 1
  ceci donne 1+1/1!+1/2!+1/3!+...+1/144! qui est une approximation de e
  avec 250 dcimales correctes}
 Convertir(144,di);
 while di.Chiffres[1]<>0 do
  begin
   Division(Rep,di,Rep,r);
   Addition(Rep,p10,Rep);
   SousB(di,1);
  end;
 {affichage des rsultats}
 Afficher(Rep); writeln;
 readln;
END.


Rsultat obtenu :

Calcul des 250 premires dcimales du nombre e.
...
27182818284590452353602874713526624977572470936999595749669676277240766303535475
94571382178525166427427466391932003059921817413596629043572900334295260595630738
13232862794349076323382988075319525101901157383418793070215408914993488416750924
47614606680

Rsultat Mupad :
27182818284590452353602874713526624977572470936999595749669676277240766303535475
94571382178525166427427466391932003059921817413596629043572900334295260595630738
13232862794349076323382988075319525101901157383418793070215408914993488416750924
4761460668
